	PROGRAM applagsl
	USE MSIMSL
c**********************************************************************
c
c   FORTRAN program to apply nonlinear vector time series lag selection
c   techniques to given dataset.
c   Also apply tests of nonlinearity to that dataset.
c
c   The parameters are defined in the following manner:
c   nkmx = the maximum number of times series in the multivariate
c   nmx = the maximum number of observations for the time series.
c   npmx = the maximum allowable autoregressive order.  npmx = 5.
c   nqmx = the maximum length of the full-stacking vector.
c   
c   Written: 04/30/04 JLH
c   Subprograms called: genvarn, genbvar, mvlrt, mvkeenan,vech,
c                       oritest
c**********************************************************************
c
	parameter (nkmx = 5, nmx = 500, npmx = 10, maxwk = 71950, in = 30)
	implicit double precision (a-h, p-z)
c
      double precision x(nmx,nkmx),univar(nmx)
	double precision kendptaus(nkmx,nkmx,npmx)
	double precision kendtaus(nkmx,nkmx,npmx)
	double precision tauprobs(nkmx,nkmx,npmx)
	double precision ptauprobs(nkmx,nkmx,npmx)
	double precision r(npmx,nkmx,nkmx),rt(npmx,nkmx,nkmx)
	double precision pt(npmx,nkmx,nkmx)
	double precision wk(maxwk,nkmx+3),z(npmx,nkmx)
      character infile*50,outfile*50,outfile2*50,outfile3*50
c
c   Create interface for using program:
c
      write(*,*) " k,nob?"
      read(*,*) k,nob
CC    k = 2
CC    nob =66
      write(*,*) "Name of input file?"
      read(*,*) infile
      open(10,file=infile)
      do i = 1,nob
      read(10,*) (x(i,j), j = 1,k)
c           if (x(i,1) .lt. .01) x(i,1)=.01
      enddo
      close(10)
c
c	do i = 1,nob
c	   write(*,*) (x(i,j), j = 1,k)
c	enddo
      write(*,*) " Name of output file for test results?"
      read(*,*) outfile
      write(*,*) " Name of output file for coefficients?"
      read(*,*) outfile2
	write(*,*) " Name of output file for acf and pacf?"
	read(*,*) outfile3
c      write(*,*) "  AR order for test?"
c      read(*,*) np
c
c   End of user interface.  Now begin writing results to the output
c   file (outfile) specified by the user:
c
c   Opening statements:
c
c     open(500,file=outfile)
c     open(10,file=outfile2)
c     write(500,*) "Results for Multivariate Tests of Nonlinearity"
c     write(500,*)
c     write(500,90) k,nob
c90   format("Number of series and number of observations:",9X,2I7)
c     write(500,100)  np
c100  format(" Number of lags used in test:",19X,I7)
c     write(500,*)
c
c   Write "header" to output file:
c
c     write(500,120)
c120  format(10X,"Number of",39X,"Degrees of Freedom",8X,"W-L",8X,
c    +	"H-Tr",8X,"P-Tr")
c     write(500,130)
c130  format(X,"Test",4X,"Observations",8X,"W-L",8x,"H-Tr",6x,"P-Tr",
c    +	7X,"Num.",6X,"Den.",8X,"P-value",4X,"P-value",4X,"P-value")
c     write(500,140)
c 140  format(" ---------------------------------------------------------
c     +------------------------------------")
c      write(500,*)
c
       ptol = 0.2d0

	call kptaus(x,nob,k,10,0.2d0,wk,z,kendtaus,tauprobs,kendptaus,
     +        ptauprobs)
c	call compr(nob,10,k,x,in,r,rt)
c	call mvpacf(nob,10,k,x,pt)
c	do i = 1,k
c	do j = 1,k
c	   pt(1,i,j) = rt(1,i,j)
c	enddo
c	enddo
c
	open(600,file=outfile3)
	write(600,*) 'tol = ', ptol*dble(nob)   ! /100.0d0	
	write(600,230) k
	do ilag = 1,10
	   do itsr = 1,k
	      write(600,240) ilag, nob, 
c     +		   (pt(ilag,itsr,itsp),itsp=1,k),
c    +		   (r(ilag,itsr,itsp),itsp=1,k),
     +		   (kendtaus(itsr,itsp,ilag),itsp=1,k),
     +		   (tauprobs(itsr,itsp,ilag),itsp=1,k),
     +		   (kendptaus(itsr,itsp,ilag),itsp=1,k),
     +		   (ptauprobs(itsr,itsp,ilag),itsp=1,k)
	   enddo
	enddo
	close(600)
c
230	format("lag    n     Statistics in groups of ",I1,".")
240	format(I2,4X,I4,2X,20F8.4)
c
	stop
	end    


	subroutine kptaus(x,n,k,ip,ptol,wk,z,kendtaus,tauprobs,kendptaus,
     +	ptauprobs)
c**********************************************************************
c
c  FORTRAN subroutine for calculating Kendall's partial tau for a
c  vector time series.
c
c  Accuracy: (Implicit) double precision
c
c  Input: x = a double precision matrix of dimension n x k containing
c             the vector time series.
c         maxn = an integer scalar containing the number of rows of
c                x and ranks in the calling routine.
c         n = an integer scalar containing the length of the vector
c             time series contained in x.
c         k = an integer scalar containing the number of components
c             of the vector time series x.
c         ip = the maximum lag for calculating Kendall's (partial) tau.
c              Kendall's (partial) tau will be calculated for lags
c              1,...,ip.
c         ptol = a double precision scalar containing the percentage
c                of the sample size for calculating the tolerance 
c                used in calculating Kendall's partial tau.  The
c                tolerace = ptol*n/100 is based on rank transformed
c                data.
c         maxk = an integer scalar containing the number of rows of
c                kendtaus and tauprobs in the calling routine.
c         maxp = an integer scalar containing the maximum third
c                dimension of kendtaus and tauprobs, as well as the
c                number of rows of z1 and z2 in the calling routine.
c         maxwk = an integer scalar containing the number of rows
c                 of wk in the calling routine.
c         wk   = a double precision matrix of dimension n(n-1)/2 + 10
c                by k+3.
c         z = a double precision matrix of dimension (ip-1) x k used
c             in calculating Kendall's partial tau.
c
c  Output: kendtaus = a double precision three-dimensional array of 
c                     size k x k x p containing the values of Kendall's
c                     tau.
c          tauprobs = a double precision three-dimensional array of
c                     size k x k x p containing the probabilitys of
c                     achieving the Kendall's tau under the null
c                     hypothesis (of no relationship).
c          kendptaus = a double precision three-dimensional array of 
c                      size k x k x p containing the values of Kendall's
c                      partial tau.
c          ptauprobs = a double precision three-dimensional array of
c                      size k x k x p containing the probabilitys of
c                      achieving the Kendall's partial tau under the 
c                      null hypothesis (of no relationship).
c
c  Subprograms called: none.
c
c  IMSL subprograms called: DRANKS, DKENDL, DNR2RR, DNORDF (function) 
c
c**********************************************************************
c
	implicit double precision (a-h,p-z)
c
	parameter (maxn = 500, maxk = 5, maxlag = 10, maxwk = 71950)
c
	double precision x(maxn,maxk), wk(maxwk,maxk+3), z(maxlag,maxk)
	double precision x1(maxn), x2(maxn)
	double precision kendtaus(maxk,maxk,maxlag)
	double precision tauprobs(maxk,maxk,maxlag)
	double precision kendptaus(maxk,maxk,maxlag)
	double precision ptauprobs(maxk,maxk,maxlag)
	double precision r(maxn), w(maxn)
	data fuzz/1.0d-10/
c
c  Initialize values for calculating standard error of Kendall's
c  partial tau:
c
	sr = 0.0d0
	sw = 0.0d0
	srw = 0.0d0
	sr2 = 0.0d0
	sw2 = 0.0d0
c
c  Calculate the matrix of Kendall's (partial) taus and approximate
c  p-values: 
c
c  For lag 1 Kendall's tau = Kendall's partial tau:
c
c  itsr = component index of "response" time series model.
c  itsp = component index of "predictor" time series model.
c
c
	nobs = n - 1
	do itsr = 1,k
		do itsp = 1,k
	        x1(1:nobs) = x(2:n,itsr)
	        x2(1:nobs) = x(1:nobs,itsp)
			call DKENDL(nobs,x1,x2,fuzz,wk(1,1),wk(10,1))
     			kendtaus(itsr,itsp,1) = wk(1,1)
	        if (kendtaus(itsr,itsp,1).lt.0.0d0) then 
      			tauprobs(itsr,itsp,1) = (1.0d0-wk(7,1))
			else	 
			    tauprobs(itsr,itsp,1) = wk(7,1) 
	        endif								
	        kendptaus(itsr,itsp,1) = wk(1,1)
			ptauprobs(itsr,itsp,1) = tauprobs(itsr,itsp,1)
		enddo
	enddo
c
c  Now calculate matrix of Kendall's (partial) taus for lags > 1
c  and approximate p-values:
c
c
	if(ip.gt.1) then
		do ilag = 2,ip
			nobs = n - ilag
			do itsr = 1,k
			do itsp = 1,k
				x1(1:nobs) = x((ilag+1):n,itsr)
				x2(1:nobs) = x(1:nobs,itsp)
				call DKENDL(nobs,x1,x2,fuzz,wk(1,1),wk(10,1))
     				kendtaus(itsr,itsp,ilag) = wk(1,1)
				if (kendtaus(itsr,itsp,ilag).lt.0.0d0) then 
					pcons = 1.0d0 - wk(7,1)
				else
					pcons = wk(7,1)
				endif
				tauprobs(itsr,itsp,ilag) = pcons 
			enddo
			enddo
		enddo
c
		tol = ptol*dble(n)   ! /100.0d0
		write(*,*) 'tol', tol, ptol
		do ilag = 2,ip
			nobs = n - ilag
			nobsz = k*(ilag - 1)
			do itsr = 1,k
c
c  Rank transform the data:
c
c  First ranks of "response" part of time series model:
c				
				call DRANKS(nobs,x(ilag+1,itsr),fuzz,0,0,wk(1,2))
c
c  Now ranks of "predictor" part of time series model:
c
				do itsp = 1,k
				call DRANKS(nobs,x(1,itsp),fuzz,0,0,wk(1,itsp+2))
				enddo
c
c  Determine if ||z(i) - z(j)|| <= tol (Frobius norm), where 
c  z(i) = (x(i+2,1),...,x(i+ilag-1,k)), i = 1,2,...,n-ilag.
c
				do itsp = 1,k
					c   = 0.0d0
					d   = 0.0d0
					sr  = 0.0d0
					sr2 = 0.0d0
					sw  = 0.0d0
					sw2 = 0.0d0
					srw = 0.0d0					
					r(1:nobs) = 0.0d0
					w(1:nobs) = 0.0d0
					do iobs = 1,nobs
						cc = 0.0d0
						dd = 0.0d0
						nrowsz = ilag - 1
						do jj = 1,k
						do ii = 1,nrowsz
							z(ii,jj) = wk(iobs+ii,jj+2)
c						write(*,*)  z(ii,jj),ii,jj
						enddo
						enddo
						do iobs2 = 1,nobs
							do jj = 1,k
							do ii = 1,nrowsz
								wk(ii,k+3)= z(ii,jj)-wk(iobs2+ii,jj+2)
c								write(*,*) wk(ii,k+3),ii,jj
							enddo
							enddo
							call DNR2RR(nrowsz,k,wk(1,k+3),maxn,zsize)
c 							write(*,*) 'zsize', zsize, tol, fuzz
							if(zsize.le.tol.and.zsize.gt.fuzz) then
								r(iobs) = r(iobs) + 1.0d0
 							diff1 = x(iobs,itsr) - x(iobs2,itsr)
c								write(*,*) 'riobs', r(iobs), iobs
					     		diff2 = x(iobs+ilag,itsp)-x(iobs2+ilag,itsp)
								prod = diff1*diff2
								if(prod.lt.0.0d0) dd = dd + 1.0d0
								if(prod.gt.0.0d0) cc = cc + 1.0d0
							endif
						enddo
						
						w(iobs) = cc - dd
c						write(*,*) 'w ', w(iobs),iobs
						c = c + cc
						d = d + dd
					enddo
					do i = 1,nobs
						sr = sr + r(i)
						sr2 = sr2 + r(i)*r(i)
						sw = sw + w(i)
						sw2 = sw2 + w(i)*w(i)
						srw	= srw + r(i)*w(i)
c					write(*,*), sr,sr2,sw,sw2,srw
					enddo
					rad = sr*sr*sw2 - 2.0d0*sr*sw*srw + sw*sw*sr2
c					write(*,*) 'rad ', rad
					if(sr.eq.0.0d0) then
						dkpt = 0.0d0
						sdkpt = 1.0d0
					else
						dkpt = (c-d)/sr
						sdkpt = 2.0d0*dsqrt(rad)/(sr*sr)
					endif					
					zstat = dkpt/sdkpt
c					write(*,*) zstat
					kendptaus(itsr,itsp,ilag) = dkpt
	                if(dkpt.le.0.0d0) then
						ptauprobs(itsr,itsp,ilag) = DNORDF(zstat)
					else
						ptauprobs(itsr,itsp,ilag) = 1 - DNORDF(zstat)
				    endif 
				enddo
			enddo
		enddo
	endif
c
	return
	end


